@php
    if (Auth('admin')->User()->dashboard_style == 'light') {
        $text = 'dark';
        $bg = 'light';
    } else {
        $bg = 'dark';
        $text = 'light';
    }
@endphp
@extends('layouts.app')
@section('content')
    @include('admin.topmenu')
    @include('admin.sidebar')
    <div class="main-panel">
        <div class="content">
            <div class="page-inner">
                <div class="mt-2 mb-4">
                    <h1 class="title1">Application Details</h1>
                    <a href="{{ route('admin.virtual-card-applications.index') }}" class="btn btn-secondary">
                        <i class="fas fa-arrow-left"></i> Back to Applications
                    </a>
                </div>
                <x-danger-alert />
                <x-success-alert />

                <div class="row">
                    <div class="col-md-8">
                        <div class="card shadow">
                            <div class="card-header">
                                <h4 class="card-title">Application Information</h4>
                            </div>
                            <div class="card-body">
                                <div class="row">
                                    <div class="col-md-6">
                                        <p><strong>Full Name:</strong> {{ $application->full_name }}</p>
                                        <p><strong>Email:</strong> {{ $application->user->email }}</p>
                                        <p><strong>Phone:</strong> {{ $application->phone_number }}</p>
                                        <p><strong>Date of Birth:</strong> {{ $application->date_of_birth }}</p>
                                    </div>
                                    <div class="col-md-6">
                                        <p><strong>Address:</strong> {{ $application->address }}</p>
                                        <p><strong>City:</strong> {{ $application->city }}</p>
                                        <p><strong>State:</strong> {{ $application->state }}</p>
                                        <p><strong>ZIP Code:</strong> {{ $application->zip_code }}</p>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="col-md-4">
                        <div class="card shadow">
                            <div class="card-header">
                                <h4 class="card-title">Card Details</h4>
                            </div>
                            <div class="card-body">
                                <p><strong>Category:</strong> {{ $application->category->name }}</p>
                                <p><strong>Card Type:</strong> {{ ucfirst(str_replace('_', ' ', $application->preferred_card_type)) }}</p>
                                <p><strong>Fee Paid:</strong> ${{ number_format($application->category->price, 2) }}</p>
                                <p><strong>Status:</strong> 
                                    @if($application->status == 'pending')
                                        <span class="badge badge-warning">Pending</span>
                                    @elseif($application->status == 'approved')
                                        <span class="badge badge-success">Approved</span>
                                    @else
                                        <span class="badge badge-danger">Rejected</span>
                                    @endif
                                </p>
                                <p><strong>Applied:</strong> {{ $application->created_at->format('M d, Y H:i') }}</p>
                            </div>
                        </div>
                    </div>
                </div>

                @if($application->status == 'pending')
                <div class="row mt-4">
                    <div class="col-12">
                        <div class="card shadow">
                            <div class="card-header">
                                <h4 class="card-title">Actions</h4>
                            </div>
                            <div class="card-body text-center">
                                <button class="btn btn-success btn-lg mr-3" onclick="approveApplication({{ $application->id }})">
                                    <i class="fas fa-check"></i> Approve Application
                                </button>
                                <button class="btn btn-danger btn-lg" onclick="rejectApplication({{ $application->id }})">
                                    <i class="fas fa-times"></i> Reject Application
                                </button>
                            </div>
                        </div>
                    </div>
                </div>
                @endif
            </div>
        </div>
    </div>

    <!-- Approve Modal -->
    <div class="modal fade" id="approveModal">
        <div class="modal-dialog">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title">Approve Application</h5>
                    <button type="button" class="close" data-dismiss="modal">&times;</button>
                </div>
                <form id="approveForm" method="POST">
                    @csrf
                    <div class="modal-body">
                        <p>Are you sure you want to approve this application? A virtual card will be generated for the user.</p>
                    </div>
                    <div class="modal-footer">
                        <button type="button" class="btn btn-secondary" data-dismiss="modal">Cancel</button>
                        <button type="submit" class="btn btn-success">
                            <i class="fas fa-check"></i> Approve & Generate Card
                        </button>
                    </div>
                </form>
            </div>
        </div>
    </div>

    <!-- Reject Modal -->
    <div class="modal fade" id="rejectModal">
        <div class="modal-dialog">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title">Reject Application</h5>
                    <button type="button" class="close" data-dismiss="modal">&times;</button>
                </div>
                <form id="rejectForm" method="POST">
                    @csrf
                    <div class="modal-body">
                        <div class="form-group">
                            <label>Reason for Rejection</label>
                            <textarea name="notes" class="form-control" rows="3" required placeholder="Please provide a reason for rejection..."></textarea>
                        </div>
                    </div>
                    <div class="modal-footer">
                        <button type="button" class="btn btn-secondary" data-dismiss="modal">Cancel</button>
                        <button type="submit" class="btn btn-danger">
                            <i class="fas fa-times"></i> Reject & Refund
                        </button>
                    </div>
                </form>
            </div>
        </div>
    </div>

    <script>
    function approveApplication(id) {
        document.getElementById('approveForm').action = `{{ url('admin/virtual-card-applications') }}/${id}/approve`;
        $('#approveModal').modal('show');
    }

    function rejectApplication(id) {
        document.getElementById('rejectForm').action = `{{ url('admin/virtual-card-applications') }}/${id}/reject`;
        $('#rejectModal').modal('show');
    }
    </script>
@endsection