@php
    if (Auth('admin')->User()->dashboard_style == 'light') {
        $text = 'dark';
        $bg = 'light';
    } else {
        $bg = 'dark';
        $text = 'light';
    }
@endphp
@extends('layouts.app')
@section('content')
    @include('admin.topmenu')
    @include('admin.sidebar')
    <div class="main-panel">
        <div class="content">
            <div class="page-inner">
                <div class="mt-2 mb-4">
                    <h1 class="title1">Card Categories Management</h1>
                </div>
                <x-danger-alert />
                <x-success-alert />

                <div class="mb-5 row">
                    <div class="mt-2 mb-3 col-lg-12">
                        <a class="btn btn-primary" href="{{ route('admin.virtual-card-categories.create') }}"><i class="fa fa-plus"></i> Add Category</a>
                    </div>
                    <div class="col-lg-12">
                        <div class="card shadow">
                            <div class="card-header">
                                <h4 class="card-title">Card Categories</h4>
                            </div>
                            <div class="card-body">
                                <div class="table-responsive">
                                    <table class="table table-hover">
                                        <thead>
                                            <tr>
                                                <th>Name</th>
                                                <th class="d-none d-md-table-cell">Price</th>
                                                <th class="d-none d-lg-table-cell">Daily Limit</th>
                                                <th class="d-none d-lg-table-cell">Monthly Limit</th>
                                                <th class="d-none d-xl-table-cell">Annual Fee</th>
                                                <th>Status</th>
                                                <th>Actions</th>
                                            </tr>
                                        </thead>
                                        <tbody>
                                            @forelse($categories as $category)
                                            <tr>
                                                <td>
                                                    <strong>{{ $category->name }}</strong><br>
                                                    <small class="text-muted d-block d-md-none">${{ number_format($category->price, 2) }}</small>
                                                    <small class="text-muted">{{ Str::limit($category->description, 30) }}</small>
                                                </td>
                                                <td class="d-none d-md-table-cell">${{ number_format($category->price, 2) }}</td>
                                                <td class="d-none d-lg-table-cell">${{ number_format($category->daily_limit, 2) }}</td>
                                                <td class="d-none d-lg-table-cell">${{ number_format($category->monthly_limit, 2) }}</td>
                                                <td class="d-none d-xl-table-cell">${{ number_format($category->annual_fee, 2) }}</td>
                                                <td>
                                                    @if($category->status == 'active')
                                                        <span class="badge badge-success">Active</span>
                                                    @else
                                                        <span class="badge badge-danger">Inactive</span>
                                                    @endif
                                                </td>
                                                <td>
                                                    <form method="POST" action="{{ route('admin.virtual-card-categories.toggle', $category->id) }}" class="d-inline">
                                                        @csrf
                                                        <button class="btn btn-sm btn-{{ $category->status == 'active' ? 'warning' : 'success' }}">
                                                            <span class="d-none d-sm-inline">{{ $category->status == 'active' ? 'Deactivate' : 'Activate' }}</span>
                                                            <i class="fa fa-{{ $category->status == 'active' ? 'pause' : 'play' }} d-sm-none"></i>
                                                        </button>
                                                    </form>
                                                </td>
                                            </tr>
                                            @empty
                                            <tr>
                                                <td colspan="7" class="text-center">No categories found</td>
                                            </tr>
                                            @endforelse
                                        </tbody>
                                    </table>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
@endsection