@extends('layouts.dasht')
@section('title', 'Card Categories')
@section('content')
<div class="container mx-auto px-4 py-6">
    <div class="mb-6">
        <h1 class="text-2xl font-bold text-gray-900 dark:text-white mb-2">Virtual Card Categories</h1>
        <p class="text-gray-600 dark:text-gray-400">Choose the perfect card for your needs</p>
    </div>

    <div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-3 gap-6">
        @foreach($categories as $category)
        <div class="bg-white dark:bg-gray-800 rounded-xl shadow-lg overflow-hidden border border-gray-200 dark:border-gray-700">
            <div class="p-6">
                <div class="flex justify-between items-start mb-4">
                    <h3 class="text-xl font-bold text-gray-900 dark:text-white">{{ $category->name }}</h3>
                    <div class="text-right">
                        <div class="text-2xl font-bold text-blue-600">${{ number_format($category->price, 2) }}</div>
                        <div class="text-sm text-gray-500">Application Fee</div>
                    </div>
                </div>

                <p class="text-gray-600 dark:text-gray-400 mb-4">{{ $category->description }}</p>

                <div class="space-y-2 mb-6">
                    <div class="flex justify-between">
                        <span class="text-sm text-gray-600 dark:text-gray-400">Daily Limit:</span>
                        <span class="text-sm font-medium text-gray-900 dark:text-white">${{ number_format($category->daily_limit, 2) }}</span>
                    </div>
                    <div class="flex justify-between">
                        <span class="text-sm text-gray-600 dark:text-gray-400">Monthly Limit:</span>
                        <span class="text-sm font-medium text-gray-900 dark:text-white">${{ number_format($category->monthly_limit, 2) }}</span>
                    </div>
                    <div class="flex justify-between">
                        <span class="text-sm text-gray-600 dark:text-gray-400">Annual Fee:</span>
                        <span class="text-sm font-medium text-gray-900 dark:text-white">${{ number_format($category->annual_fee, 2) }}</span>
                    </div>
                </div>

                <div class="mb-6">
                    <h4 class="text-sm font-semibold text-gray-900 dark:text-white mb-2">Features:</h4>
                    <ul class="text-sm text-gray-600 dark:text-gray-400 space-y-1">
                        <li>• Instant card generation</li>
                        <li>• Online transactions</li>
                        <li>• Real-time balance updates</li>
                        <li>• 24/7 customer support</li>
                    </ul>
                </div>

                <a href="{{ route('user.virtual-cards.apply', $category->id) }}" 
                   class="w-full bg-blue-600 text-white py-3 px-4 rounded-lg hover:bg-blue-700 transition-colors font-medium text-center block">
                    Apply Now
                </a>
            </div>
        </div>
        @endforeach
    </div>
</div>
@endsection