<?php
    if (Auth('admin')->User()->dashboard_style == 'light') {
        $text = 'dark';
        $bg = 'light';
    } else {
        $bg = 'dark';
        $text = 'light';
    }
?>

<?php $__env->startSection('content'); ?>
    <?php echo $__env->make('admin.topmenu', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
    <?php echo $__env->make('admin.sidebar', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
    <div class="main-panel">
        <div class="content">
            <div class="page-inner">
                <div class="mt-2 mb-4">
                    <h1 class="title1">Card Categories Management</h1>
                </div>
                <?php if (isset($component)) { $__componentOriginalc254754b9d5db91d5165876f9d051922ca0066f4 = $component; } ?>
<?php $component = $__env->getContainer()->make(Illuminate\View\AnonymousComponent::class, ['view' => 'components.danger-alert','data' => []]); ?>
<?php $component->withName('danger-alert'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php $component->withAttributes([]); ?>
<?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__componentOriginalc254754b9d5db91d5165876f9d051922ca0066f4)): ?>
<?php $component = $__componentOriginalc254754b9d5db91d5165876f9d051922ca0066f4; ?>
<?php unset($__componentOriginalc254754b9d5db91d5165876f9d051922ca0066f4); ?>
<?php endif; ?>
                <?php if (isset($component)) { $__componentOriginalc254754b9d5db91d5165876f9d051922ca0066f4 = $component; } ?>
<?php $component = $__env->getContainer()->make(Illuminate\View\AnonymousComponent::class, ['view' => 'components.success-alert','data' => []]); ?>
<?php $component->withName('success-alert'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php $component->withAttributes([]); ?>
<?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__componentOriginalc254754b9d5db91d5165876f9d051922ca0066f4)): ?>
<?php $component = $__componentOriginalc254754b9d5db91d5165876f9d051922ca0066f4; ?>
<?php unset($__componentOriginalc254754b9d5db91d5165876f9d051922ca0066f4); ?>
<?php endif; ?>

                <div class="mb-5 row">
                    <div class="mt-2 mb-3 col-lg-12">
                        <a class="btn btn-primary" href="<?php echo e(route('admin.virtual-card-categories.create')); ?>"><i class="fa fa-plus"></i> Add Category</a>
                    </div>
                    <div class="col-lg-12">
                        <div class="card shadow">
                            <div class="card-header">
                                <h4 class="card-title">Card Categories</h4>
                            </div>
                            <div class="card-body">
                                <div class="table-responsive">
                                    <table class="table table-hover">
                                        <thead>
                                            <tr>
                                                <th>Name</th>
                                                <th class="d-none d-md-table-cell">Price</th>
                                                <th class="d-none d-lg-table-cell">Daily Limit</th>
                                                <th class="d-none d-lg-table-cell">Monthly Limit</th>
                                                <th class="d-none d-xl-table-cell">Annual Fee</th>
                                                <th>Status</th>
                                                <th>Actions</th>
                                            </tr>
                                        </thead>
                                        <tbody>
                                            <?php $__empty_1 = true; $__currentLoopData = $categories; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $category): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                                            <tr>
                                                <td>
                                                    <strong><?php echo e($category->name); ?></strong><br>
                                                    <small class="text-muted d-block d-md-none">$<?php echo e(number_format($category->price, 2)); ?></small>
                                                    <small class="text-muted"><?php echo e(Str::limit($category->description, 30)); ?></small>
                                                </td>
                                                <td class="d-none d-md-table-cell">$<?php echo e(number_format($category->price, 2)); ?></td>
                                                <td class="d-none d-lg-table-cell">$<?php echo e(number_format($category->daily_limit, 2)); ?></td>
                                                <td class="d-none d-lg-table-cell">$<?php echo e(number_format($category->monthly_limit, 2)); ?></td>
                                                <td class="d-none d-xl-table-cell">$<?php echo e(number_format($category->annual_fee, 2)); ?></td>
                                                <td>
                                                    <?php if($category->status == 'active'): ?>
                                                        <span class="badge badge-success">Active</span>
                                                    <?php else: ?>
                                                        <span class="badge badge-danger">Inactive</span>
                                                    <?php endif; ?>
                                                </td>
                                                <td>
                                                    <form method="POST" action="<?php echo e(route('admin.virtual-card-categories.toggle', $category->id)); ?>" class="d-inline">
                                                        <?php echo csrf_field(); ?>
                                                        <button class="btn btn-sm btn-<?php echo e($category->status == 'active' ? 'warning' : 'success'); ?>">
                                                            <span class="d-none d-sm-inline"><?php echo e($category->status == 'active' ? 'Deactivate' : 'Activate'); ?></span>
                                                            <i class="fa fa-<?php echo e($category->status == 'active' ? 'pause' : 'play'); ?> d-sm-none"></i>
                                                        </button>
                                                    </form>
                                                </td>
                                            </tr>
                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                                            <tr>
                                                <td colspan="7" class="text-center">No categories found</td>
                                            </tr>
                                            <?php endif; ?>
                                        </tbody>
                                    </table>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\xampp80\htdocs\ttt2\copy\resources\views/admin/virtual-card-categories/index.blade.php ENDPATH**/ ?>