<?php
    if (Auth('admin')->User()->dashboard_style == 'light') {
        $text = 'dark';
        $bg = 'light';
    } else {
        $bg = 'dark';
        $text = 'light';
    }
?>

<?php $__env->startSection('content'); ?>
    <?php echo $__env->make('admin.topmenu', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
    <?php echo $__env->make('admin.sidebar', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
    <div class="main-panel">
        <div class="content">
            <div class="page-inner">
                <div class="mt-2 mb-4">
                    <h1 class="title1">Virtual Cards Management</h1>
                </div>
                <?php if (isset($component)) { $__componentOriginalc254754b9d5db91d5165876f9d051922ca0066f4 = $component; } ?>
<?php $component = $__env->getContainer()->make(Illuminate\View\AnonymousComponent::class, ['view' => 'components.danger-alert','data' => []]); ?>
<?php $component->withName('danger-alert'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php $component->withAttributes([]); ?>
<?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__componentOriginalc254754b9d5db91d5165876f9d051922ca0066f4)): ?>
<?php $component = $__componentOriginalc254754b9d5db91d5165876f9d051922ca0066f4; ?>
<?php unset($__componentOriginalc254754b9d5db91d5165876f9d051922ca0066f4); ?>
<?php endif; ?>
                <?php if (isset($component)) { $__componentOriginalc254754b9d5db91d5165876f9d051922ca0066f4 = $component; } ?>
<?php $component = $__env->getContainer()->make(Illuminate\View\AnonymousComponent::class, ['view' => 'components.success-alert','data' => []]); ?>
<?php $component->withName('success-alert'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php $component->withAttributes([]); ?>
<?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__componentOriginalc254754b9d5db91d5165876f9d051922ca0066f4)): ?>
<?php $component = $__componentOriginalc254754b9d5db91d5165876f9d051922ca0066f4; ?>
<?php unset($__componentOriginalc254754b9d5db91d5165876f9d051922ca0066f4); ?>
<?php endif; ?>

                <div class="mb-5 row">
                    <div class="mt-2 mb-3 col-lg-12">
                        <a class="btn btn-primary" href="<?php echo e(route('admin.virtual-cards.create')); ?>"><i class="fa fa-plus"></i> Create New Card</a>
                    </div>
                    <div class="col-lg-12">
                        <div class="card shadow">
                            <div class="card-header">
                                <h4 class="card-title">Virtual Cards</h4>
                            </div>
                            <div class="card-body">
                                <div class="table-responsive">
                                    <table class="table table-hover">
                                        <thead>
                                            <tr>
                                                <th>User</th>
                                                <th class="d-none d-md-table-cell">Card Number</th>
                                                <th class="d-none d-lg-table-cell">Balance</th>
                                                <th>Status</th>
                                                <th class="d-none d-lg-table-cell">Created</th>
                                                <th>Actions</th>
                                            </tr>
                                        </thead>
                                        <tbody>
                                            <?php $__empty_1 = true; $__currentLoopData = $cards; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $card): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                                            <tr>
                                                <td>
                                                    <strong><?php echo e($card->user->name); ?></strong><br>
                                                    <small class="text-muted"><?php echo e($card->user->email); ?></small>
                                                    <div class="d-md-none mt-1">
                                                        <small class="text-info"><?php echo e($card->masked_card_number); ?></small><br>
                                                        <small class="text-success">$<?php echo e(number_format($card->balance, 2)); ?></small>
                                                    </div>
                                                </td>
                                                <td class="d-none d-md-table-cell"><?php echo e($card->masked_card_number); ?></td>
                                                <td class="d-none d-lg-table-cell">$<?php echo e(number_format($card->balance, 2)); ?></td>
                                                <td>
                                                    <span class="badge badge-<?php echo e($card->status == 'active' ? 'success' : 'danger'); ?>">
                                                        <?php echo e(ucfirst($card->status)); ?>

                                                    </span>
                                                </td>
                                                <td class="d-none d-lg-table-cell"><?php echo e($card->created_at->format('M d, Y')); ?></td>
                                                <td>
                                                    <div class="btn-group-vertical btn-group-sm d-lg-none">
                                                        <form method="POST" action="<?php echo e(route('admin.virtual-cards.update-status', $card->id)); ?>" class="d-inline">
                                                            <?php echo csrf_field(); ?>
                                                            <input type="hidden" name="status" value="<?php echo e($card->status == 'active' ? 'blocked' : 'active'); ?>">
                                                            <button class="btn btn-sm btn-<?php echo e($card->status == 'active' ? 'warning' : 'success'); ?> mb-1">
                                                                <i class="fa fa-<?php echo e($card->status == 'active' ? 'pause' : 'play'); ?>"></i>
                                                            </button>
                                                        </form>
                                                        <form method="POST" action="<?php echo e(route('admin.virtual-cards.destroy', $card->id)); ?>" class="d-inline">
                                                            <?php echo csrf_field(); ?> <?php echo method_field('DELETE'); ?>
                                                            <button class="btn btn-sm btn-danger" onclick="return confirm('Delete this card?')">
                                                                <i class="fa fa-trash"></i>
                                                            </button>
                                                        </form>
                                                    </div>
                                                    <div class="d-none d-lg-block">
                                                        <form method="POST" action="<?php echo e(route('admin.virtual-cards.update-status', $card->id)); ?>" class="d-inline">
                                                            <?php echo csrf_field(); ?>
                                                            <input type="hidden" name="status" value="<?php echo e($card->status == 'active' ? 'blocked' : 'active'); ?>">
                                                            <button class="btn btn-sm btn-<?php echo e($card->status == 'active' ? 'warning' : 'success'); ?>">
                                                                <?php echo e($card->status == 'active' ? 'Block' : 'Activate'); ?>

                                                            </button>
                                                        </form>
                                                        <form method="POST" action="<?php echo e(route('admin.virtual-cards.destroy', $card->id)); ?>" class="d-inline">
                                                            <?php echo csrf_field(); ?> <?php echo method_field('DELETE'); ?>
                                                            <button class="btn btn-sm btn-danger" onclick="return confirm('Delete this card?')">Delete</button>
                                                        </form>
                                                    </div>
                                                </td>
                                            </tr>
                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                                            <tr>
                                                <td colspan="6" class="text-center">No virtual cards found</td>
                                            </tr>
                                            <?php endif; ?>
                                        </tbody>
                                    </table>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\xampp80\htdocs\ttt2\copy\resources\views/admin/virtual-cards/index.blade.php ENDPATH**/ ?>