<?php
    if (Auth('admin')->User()->dashboard_style == 'light') {
        $text = 'dark';
        $bg = 'light';
    } else {
        $bg = 'dark';
        $text = 'light';
    }
?>

<?php $__env->startSection('content'); ?>
    <?php echo $__env->make('admin.topmenu', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
    <?php echo $__env->make('admin.sidebar', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
    <div class="main-panel">
        <div class="content">
            <div class="page-inner">
                <div class="mt-2 mb-4">
                    <h1 class="title1">Card Applications Management</h1>
                </div>
                <?php if (isset($component)) { $__componentOriginalc254754b9d5db91d5165876f9d051922ca0066f4 = $component; } ?>
<?php $component = $__env->getContainer()->make(Illuminate\View\AnonymousComponent::class, ['view' => 'components.danger-alert','data' => []]); ?>
<?php $component->withName('danger-alert'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php $component->withAttributes([]); ?>
<?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__componentOriginalc254754b9d5db91d5165876f9d051922ca0066f4)): ?>
<?php $component = $__componentOriginalc254754b9d5db91d5165876f9d051922ca0066f4; ?>
<?php unset($__componentOriginalc254754b9d5db91d5165876f9d051922ca0066f4); ?>
<?php endif; ?>
                <?php if (isset($component)) { $__componentOriginalc254754b9d5db91d5165876f9d051922ca0066f4 = $component; } ?>
<?php $component = $__env->getContainer()->make(Illuminate\View\AnonymousComponent::class, ['view' => 'components.success-alert','data' => []]); ?>
<?php $component->withName('success-alert'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php $component->withAttributes([]); ?>
<?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__componentOriginalc254754b9d5db91d5165876f9d051922ca0066f4)): ?>
<?php $component = $__componentOriginalc254754b9d5db91d5165876f9d051922ca0066f4; ?>
<?php unset($__componentOriginalc254754b9d5db91d5165876f9d051922ca0066f4); ?>
<?php endif; ?>

                <div class="mb-5 row">
                    <div class="col-lg-12">
                        <div class="card shadow">
                            <div class="card-header">
                                <h4 class="card-title">Pending Applications</h4>
                            </div>
                            <div class="card-body">
                                <div class="table-responsive">
                                    <table class="table table-hover">
                                        <thead>
                                            <tr>
                                                <th>User</th>
                                                <th class="d-none d-md-table-cell">Category</th>
                                                <th class="d-none d-lg-table-cell">Card Type</th>
                                                <th class="d-none d-md-table-cell">Fee Paid</th>
                                                <th>Status</th>
                                                <th class="d-none d-lg-table-cell">Applied</th>
                                                <th>Actions</th>
                                            </tr>
                                        </thead>
                                        <tbody>
                                            <?php $__empty_1 = true; $__currentLoopData = $applications; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $application): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                                            <tr>
                                                <td>
                                                    <strong><?php echo e($application->user->name); ?></strong><br>
                                                    <small class="text-muted"><?php echo e($application->user->email); ?></small>
                                                    <div class="d-md-none mt-1">
                                                        <small class="text-info"><?php echo e($application->category->name); ?></small><br>
                                                        <small class="text-success">$<?php echo e(number_format($application->category->price, 2)); ?></small>
                                                    </div>
                                                </td>
                                                <td class="d-none d-md-table-cell"><?php echo e($application->category->name); ?></td>
                                                <td class="d-none d-lg-table-cell">
                                                    <span class="badge badge-info"><?php echo e(ucfirst(str_replace('_', ' ', $application->preferred_card_type))); ?></span>
                                                </td>
                                                <td class="d-none d-md-table-cell">$<?php echo e(number_format($application->category->price, 2)); ?></td>
                                                <td>
                                                    <?php if($application->status == 'pending'): ?>
                                                        <span class="badge badge-warning">Pending</span>
                                                    <?php elseif($application->status == 'approved'): ?>
                                                        <span class="badge badge-success">Approved</span>
                                                    <?php else: ?>
                                                        <span class="badge badge-danger">Rejected</span>
                                                    <?php endif; ?>
                                                </td>
                                                <td class="d-none d-lg-table-cell"><?php echo e($application->created_at->format('M d, Y')); ?></td>
                                                <td>
                                                    <div class="btn-group-vertical btn-group-sm d-lg-none">
                                                        <?php if($application->status == 'pending'): ?>
                                                        <button class="btn btn-success btn-sm mb-1" onclick="approveApplication(<?php echo e($application->id); ?>)">
                                                            <i class="fas fa-check"></i>
                                                        </button>
                                                        <button class="btn btn-danger btn-sm mb-1" onclick="rejectApplication(<?php echo e($application->id); ?>)">
                                                            <i class="fas fa-times"></i>
                                                        </button>
                                                        <?php endif; ?>
                                                        <button class="btn btn-info btn-sm" onclick="viewApplication(<?php echo e($application->id); ?>)">
                                                            <i class="fas fa-eye"></i>
                                                        </button>
                                                    </div>
                                                    <div class="d-none d-lg-block">
                                                        <?php if($application->status == 'pending'): ?>
                                                        <button class="btn btn-sm btn-success" onclick="approveApplication(<?php echo e($application->id); ?>)">
                                                            <i class="fas fa-check"></i> Approve
                                                        </button>
                                                        <button class="btn btn-sm btn-danger" onclick="rejectApplication(<?php echo e($application->id); ?>)">
                                                            <i class="fas fa-times"></i> Reject
                                                        </button>
                                                        <?php endif; ?>
                                                        <button class="btn btn-sm btn-info" onclick="viewApplication(<?php echo e($application->id); ?>)">
                                                            <i class="fas fa-eye"></i> View
                                                        </button>
                                                    </div>
                                                </td>
                                            </tr>
                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                                            <tr>
                                                <td colspan="7" class="text-center">No applications found</td>
                                            </tr>
                                            <?php endif; ?>
                                        </tbody>
                                    </table>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- Approve Modal -->
    <div class="modal fade" id="approveModal">
        <div class="modal-dialog">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title">Approve Application</h5>
                    <button type="button" class="close" data-dismiss="modal">&times;</button>
                </div>
                <form id="approveForm" method="POST">
                    <?php echo csrf_field(); ?>
                    <div class="modal-body">
                        <p>Are you sure you want to approve this application? A virtual card will be generated for the user.</p>
                    </div>
                    <div class="modal-footer">
                        <button type="button" class="btn btn-secondary" data-dismiss="modal">Cancel</button>
                        <button type="submit" class="btn btn-success">
                            <i class="fas fa-check"></i> Approve & Generate Card
                        </button>
                    </div>
                </form>
            </div>
        </div>
    </div>

    <!-- Reject Modal -->
    <div class="modal fade" id="rejectModal">
        <div class="modal-dialog">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title">Reject Application</h5>
                    <button type="button" class="close" data-dismiss="modal">&times;</button>
                </div>
                <form id="rejectForm" method="POST">
                    <?php echo csrf_field(); ?>
                    <div class="modal-body">
                        <div class="form-group">
                            <label>Reason for Rejection</label>
                            <textarea name="notes" class="form-control" rows="3" required placeholder="Please provide a reason for rejection..."></textarea>
                        </div>
                    </div>
                    <div class="modal-footer">
                        <button type="button" class="btn btn-secondary" data-dismiss="modal">Cancel</button>
                        <button type="submit" class="btn btn-danger">
                            <i class="fas fa-times"></i> Reject & Refund
                        </button>
                    </div>
                </form>
            </div>
        </div>
    </div>

    <script>
    function approveApplication(id) {
        document.getElementById('approveForm').action = `<?php echo e(url('admin/virtual-card-applications')); ?>/${id}/approve`;
        $('#approveModal').modal('show');
    }

    function rejectApplication(id) {
        document.getElementById('rejectForm').action = `<?php echo e(url('admin/virtual-card-applications')); ?>/${id}/reject`;
        $('#rejectModal').modal('show');
    }

    function viewApplication(id) {
        window.location.href = `<?php echo e(url('admin/virtual-card-applications')); ?>/${id}`;
    }
    </script>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\xampp80\htdocs\ttt2\copy\resources\views/admin/virtual-card-applications/index.blade.php ENDPATH**/ ?>