<?php
    if (Auth('admin')->User()->dashboard_style == 'light') {
        $text = 'dark';
        $bg = 'light';
    } else {
        $bg = 'dark';
        $text = 'light';
    }
?>

<?php $__env->startSection('content'); ?>
    <?php echo $__env->make('admin.topmenu', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
    <?php echo $__env->make('admin.sidebar', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
    <div class="main-panel">
        <div class="content">
            <div class="page-inner">
                <div class="mt-2 mb-4">
                    <h1 class="title1">Application Details</h1>
                    <a href="<?php echo e(route('admin.virtual-card-applications.index')); ?>" class="btn btn-secondary">
                        <i class="fas fa-arrow-left"></i> Back to Applications
                    </a>
                </div>
                <?php if (isset($component)) { $__componentOriginalc254754b9d5db91d5165876f9d051922ca0066f4 = $component; } ?>
<?php $component = $__env->getContainer()->make(Illuminate\View\AnonymousComponent::class, ['view' => 'components.danger-alert','data' => []]); ?>
<?php $component->withName('danger-alert'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php $component->withAttributes([]); ?>
<?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__componentOriginalc254754b9d5db91d5165876f9d051922ca0066f4)): ?>
<?php $component = $__componentOriginalc254754b9d5db91d5165876f9d051922ca0066f4; ?>
<?php unset($__componentOriginalc254754b9d5db91d5165876f9d051922ca0066f4); ?>
<?php endif; ?>
                <?php if (isset($component)) { $__componentOriginalc254754b9d5db91d5165876f9d051922ca0066f4 = $component; } ?>
<?php $component = $__env->getContainer()->make(Illuminate\View\AnonymousComponent::class, ['view' => 'components.success-alert','data' => []]); ?>
<?php $component->withName('success-alert'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php $component->withAttributes([]); ?>
<?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__componentOriginalc254754b9d5db91d5165876f9d051922ca0066f4)): ?>
<?php $component = $__componentOriginalc254754b9d5db91d5165876f9d051922ca0066f4; ?>
<?php unset($__componentOriginalc254754b9d5db91d5165876f9d051922ca0066f4); ?>
<?php endif; ?>

                <div class="row">
                    <div class="col-md-8">
                        <div class="card shadow">
                            <div class="card-header">
                                <h4 class="card-title">Application Information</h4>
                            </div>
                            <div class="card-body">
                                <div class="row">
                                    <div class="col-md-6">
                                        <p><strong>Full Name:</strong> <?php echo e($application->full_name); ?></p>
                                        <p><strong>Email:</strong> <?php echo e($application->user->email); ?></p>
                                        <p><strong>Phone:</strong> <?php echo e($application->phone_number); ?></p>
                                        <p><strong>Date of Birth:</strong> <?php echo e($application->date_of_birth); ?></p>
                                    </div>
                                    <div class="col-md-6">
                                        <p><strong>Address:</strong> <?php echo e($application->address); ?></p>
                                        <p><strong>City:</strong> <?php echo e($application->city); ?></p>
                                        <p><strong>State:</strong> <?php echo e($application->state); ?></p>
                                        <p><strong>ZIP Code:</strong> <?php echo e($application->zip_code); ?></p>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="col-md-4">
                        <div class="card shadow">
                            <div class="card-header">
                                <h4 class="card-title">Card Details</h4>
                            </div>
                            <div class="card-body">
                                <p><strong>Category:</strong> <?php echo e($application->category->name); ?></p>
                                <p><strong>Card Type:</strong> <?php echo e(ucfirst(str_replace('_', ' ', $application->preferred_card_type))); ?></p>
                                <p><strong>Fee Paid:</strong> $<?php echo e(number_format($application->category->price, 2)); ?></p>
                                <p><strong>Status:</strong> 
                                    <?php if($application->status == 'pending'): ?>
                                        <span class="badge badge-warning">Pending</span>
                                    <?php elseif($application->status == 'approved'): ?>
                                        <span class="badge badge-success">Approved</span>
                                    <?php else: ?>
                                        <span class="badge badge-danger">Rejected</span>
                                    <?php endif; ?>
                                </p>
                                <p><strong>Applied:</strong> <?php echo e($application->created_at->format('M d, Y H:i')); ?></p>
                            </div>
                        </div>
                    </div>
                </div>

                <?php if($application->status == 'pending'): ?>
                <div class="row mt-4">
                    <div class="col-12">
                        <div class="card shadow">
                            <div class="card-header">
                                <h4 class="card-title">Actions</h4>
                            </div>
                            <div class="card-body text-center">
                                <button class="btn btn-success btn-lg mr-3" onclick="approveApplication(<?php echo e($application->id); ?>)">
                                    <i class="fas fa-check"></i> Approve Application
                                </button>
                                <button class="btn btn-danger btn-lg" onclick="rejectApplication(<?php echo e($application->id); ?>)">
                                    <i class="fas fa-times"></i> Reject Application
                                </button>
                            </div>
                        </div>
                    </div>
                </div>
                <?php endif; ?>
            </div>
        </div>
    </div>

    <!-- Approve Modal -->
    <div class="modal fade" id="approveModal">
        <div class="modal-dialog">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title">Approve Application</h5>
                    <button type="button" class="close" data-dismiss="modal">&times;</button>
                </div>
                <form id="approveForm" method="POST">
                    <?php echo csrf_field(); ?>
                    <div class="modal-body">
                        <p>Are you sure you want to approve this application? A virtual card will be generated for the user.</p>
                    </div>
                    <div class="modal-footer">
                        <button type="button" class="btn btn-secondary" data-dismiss="modal">Cancel</button>
                        <button type="submit" class="btn btn-success">
                            <i class="fas fa-check"></i> Approve & Generate Card
                        </button>
                    </div>
                </form>
            </div>
        </div>
    </div>

    <!-- Reject Modal -->
    <div class="modal fade" id="rejectModal">
        <div class="modal-dialog">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title">Reject Application</h5>
                    <button type="button" class="close" data-dismiss="modal">&times;</button>
                </div>
                <form id="rejectForm" method="POST">
                    <?php echo csrf_field(); ?>
                    <div class="modal-body">
                        <div class="form-group">
                            <label>Reason for Rejection</label>
                            <textarea name="notes" class="form-control" rows="3" required placeholder="Please provide a reason for rejection..."></textarea>
                        </div>
                    </div>
                    <div class="modal-footer">
                        <button type="button" class="btn btn-secondary" data-dismiss="modal">Cancel</button>
                        <button type="submit" class="btn btn-danger">
                            <i class="fas fa-times"></i> Reject & Refund
                        </button>
                    </div>
                </form>
            </div>
        </div>
    </div>

    <script>
    function approveApplication(id) {
        document.getElementById('approveForm').action = `<?php echo e(url('admin/virtual-card-applications')); ?>/${id}/approve`;
        $('#approveModal').modal('show');
    }

    function rejectApplication(id) {
        document.getElementById('rejectForm').action = `<?php echo e(url('admin/virtual-card-applications')); ?>/${id}/reject`;
        $('#rejectModal').modal('show');
    }
    </script>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\xampp80\htdocs\ttt2\copy\resources\views/admin/virtual-card-applications/show.blade.php ENDPATH**/ ?>